require("dotenv").config();
const express = require("express");
const fs = require("fs");
const cors = require("cors");
const https = require("https");
const path = require("path");

const app = express();
const registrationRoutes = require("./routes/registration");

app.use(express.json());

// SSL Certificate
const options = {
  key: fs.readFileSync(path.join(__dirname, "ssl.key")),
  cert: fs.readFileSync(path.join(__dirname, "ssl.crt")),
};

// CORS
app.use(cors({
  origin: [
    'https://console.ftvassets.in',
    'http://localhost:8080',
    'http://localhost:5000'
  ],
  credentials: true,
  methods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
  allowedHeaders: ['Content-Type', 'Authorization']
}));

// REMOVE THIS: app.options('*', cors());

// Static
app.use("/uploads", express.static(path.join(__dirname, "uploads")));

// Routes
app.use("/api", registrationRoutes);

// HTTPS Server
const server = https.createServer(options, app);

server.listen(5000, () => {
  console.log("Node HTTPS server running on port 5000");
});
