const nodemailer = require("nodemailer");
const fs = require("fs");
const path = require("path");

// Email configuration - Update these with your SMTP settings
const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST || "smtp.gmail.com",
  port: process.env.SMTP_PORT || 587,
  secure: false, // true for 465, false for other ports
  auth: {
    user: process.env.SMTP_USER || "business@ftv.ind.in",
    pass: process.env.SMTP_PASS || "bohjspazpvctxhmud",
  },
});

// Send thank you email to user
exports.sendThankYouEmail = async (userEmail, userName) => {
  try {
    const mailOptions = {
      from: process.env.SMTP_FROM || process.env.SMTP_USER || "business@ftv.ind.in",
      to: userEmail,
      subject: "Thank You for Your Submission - FTV Assets",
      html: `
        <!DOCTYPE html>
        <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #4CAF50; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f9f9f9; }
            .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header">
              <h1>Thank You!</h1>
            </div>
            <div class="content">
              <p>Dear ${userName},</p>
              <p>Thank you for submitting your documents. We have successfully received your submission.</p>
              <p>Our team will review your documents and get back to you shortly.</p>
              <p>If you have any questions, please feel free to contact us.</p>
              <p>Best regards,<br>FTV Assets Team</p>
            </div>
            <div class="footer">
              <p>This is an automated email. Please do not reply to this message.</p>
            </div>
          </div>
        </body>
        </html>
      `,
    };

    await transporter.sendMail(mailOptions);
    console.log(`Thank you email sent to ${userEmail}`);
    return true;
  } catch (error) {
    console.error("Error sending thank you email:", error);
    return false;
  }
};

// Send admin notification email with user details and clickable download links
exports.sendAdminNotification = async (adminEmail, userData, documentPaths, baseUrl) => {
  try {
    const basePath = path.join(__dirname, "..");
    
    // Build download links for ALL document types (show all, even if missing)
    const allDocTypes = [
      { key: 'aadhaar', label: 'Aadhaar' },
      { key: 'pan', label: 'PAN' },
      { key: 'passport', label: 'Passport' },
      { key: 'signature', label: 'Signature' },
      { key: 'mou', label: 'MOU' }
    ];
    
    const downloadLinks = [];
    
    // Debug: Log what we received
    console.log("=== EMAIL SERVICE DEBUG ===");
    console.log("Document paths received:", documentPaths);
    console.log("Base URL:", baseUrl);
    
    for (const docType of allDocTypes) {
      const filePath = documentPaths[docType.key];
      console.log(`Processing ${docType.label}:`, filePath, `(type: ${typeof filePath})`);
      
      // Check if filePath exists - be lenient with type checking
      // Convert to string if needed (database might return Buffer or other types)
      const filePathStr = filePath ? String(filePath).trim() : '';
      
      if (filePathStr && filePathStr.length > 0 && filePathStr !== 'null' && filePathStr !== 'undefined') {
        try {
          // Convert Windows path to URL path
          let urlPath = filePathStr.replace(/\\/g, "/").trim();
          console.log(`  Converted path: ${urlPath}`);
          
          // Extract the relative path starting from "uploads"
          // The path might be absolute (C:/path/to/uploads/...) or relative (uploads/...)
          let cleanPath = urlPath;
          const uploadsIndex = urlPath.toLowerCase().indexOf("uploads");
          
          if (uploadsIndex !== -1) {
            // Extract everything from "uploads" onwards
            cleanPath = urlPath.substring(uploadsIndex);
            console.log(`  Extracted path: ${cleanPath}`);
          } else {
            // If "uploads" not found, the path might already be relative or in a different format
            // Check if it looks like it should start with uploads
            if (!cleanPath.startsWith("uploads") && !cleanPath.startsWith("/uploads")) {
              // Try to construct the path - assume it's relative to uploads folder
              // Remove any leading path components before uploads
              const parts = cleanPath.split("/");
              const uploadsPartIndex = parts.findIndex(p => p.toLowerCase().includes("upload"));
              if (uploadsPartIndex !== -1) {
                cleanPath = parts.slice(uploadsPartIndex).join("/");
                console.log(`  Reconstructed path: ${cleanPath}`);
              } else {
                // Last resort: prepend uploads if it looks like a user folder path
                if (cleanPath.includes("users/")) {
                  const usersIndex = cleanPath.indexOf("users/");
                  cleanPath = "uploads/" + cleanPath.substring(usersIndex);
                  console.log(`  Added uploads prefix: ${cleanPath}`);
                }
              }
            }
          }
          
          // Ensure it starts with /
          cleanPath = cleanPath.startsWith("/") ? cleanPath : `/${cleanPath}`;
          const downloadUrl = `${baseUrl}${cleanPath}`;
          const fileName = path.basename(filePathStr);
          
          console.log(`  Final URL: ${downloadUrl}`);
          
          downloadLinks.push({
            type: docType.label,
            url: downloadUrl,
            fileName: fileName,
            exists: true,
          });
        } catch (error) {
          console.error(`  Error processing ${docType.label}:`, error);
          downloadLinks.push({
            type: docType.label,
            url: null,
            fileName: null,
            exists: false,
          });
        }
      } else {
        // Show missing documents too
        console.log(`  ${docType.label}: No file path (value: ${filePath}, type: ${typeof filePath})`);
        downloadLinks.push({
          type: docType.label,
          url: null,
          fileName: null,
          exists: false,
        });
      }
    }
    
    console.log("Final download links:", downloadLinks);

    const mailOptions = {
      from: process.env.SMTP_FROM || process.env.SMTP_USER || "noreply@ftvassets.in",
      to: adminEmail,
      subject: `New Document Submission - ${userData.fullname}`,
      html: `
        <!DOCTYPE html>
        <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 800px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2196F3; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; background-color: #f9f9f9; }
            .details { background-color: white; padding: 15px; margin: 10px 0; border-left: 4px solid #2196F3; }
            .label { font-weight: bold; color: #555; }
            .value { margin-bottom: 10px; }
            .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
            table { width: 100%; border-collapse: collapse; margin: 15px 0; }
            td { padding: 8px; border-bottom: 1px solid #ddd; }
            .label-cell { width: 30%; font-weight: bold; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header">
              <h1>New Document Submission</h1>
            </div>
            <div class="content">
              <p>A new user has submitted their documents. Please find the details below:</p>
              
              <div class="details">
                <h2>User Information</h2>
                <table>
                  <tr>
                    <td class="label-cell">Full Name:</td>
                    <td>${userData.fullname || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Contact:</td>
                    <td>${userData.contact || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Email:</td>
                    <td>${userData.email || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Address:</td>
                    <td>${userData.address || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Office Address:</td>
                    <td>${userData.office_address || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Office Contact:</td>
                    <td>${userData.office_contact || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Work Experience:</td>
                    <td>${userData.work_experience || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Aadhaar Number:</td>
                    <td>${userData.aadhaar_number || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">PAN Number:</td>
                    <td>${userData.pan_number || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">Passport Number:</td>
                    <td>${userData.passport_number || "N/A"}</td>
                  </tr>
                  <tr>
                    <td class="label-cell">User ID:</td>
                    <td>${userData.user_id || "N/A"}</td>
                  </tr>
                </table>
              </div>

              <div class="details">
                <h2>Uploaded Documents</h2>
                <p>Click on the links below to download the documents:</p>
                <ul style="list-style: none; padding: 0;">
                  ${downloadLinks.map(link => 
                      link.exists 
                        ? `<li style="margin: 10px 0; padding: 10px; background-color: #f0f0f0; border-radius: 5px;">
                            <strong>${link.type}:</strong> 
                            <a href="${link.url}" style="color: #2196F3; text-decoration: none; font-weight: bold; margin-left: 10px;" target="_blank">
                              📥 Download ${link.fileName}
                            </a>
                          </li>`
                        : `<li style="margin: 10px 0; padding: 10px; background-color: #ffebee; border-radius: 5px; color: #c62828;">
                            <strong>${link.type}:</strong> 
                            <span style="margin-left: 10px; color: #c62828;">❌ Not uploaded</span>
                          </li>`
                    ).join("")
                  }
                </ul>
              </div>

              <p style="margin-top: 20px; padding: 15px; background-color: #e3f2fd; border-radius: 5px;">
                <strong>Note:</strong> Click on the download links above to access the documents directly.
              </p>
            </div>
            <div class="footer">
              <p>This is an automated notification from FTV Assets MOU System.</p>
            </div>
          </div>
        </body>
        </html>
      `,
    };

    await transporter.sendMail(mailOptions);
    console.log(`Admin notification email sent to ${adminEmail}`);
    return true;
  } catch (error) {
    console.error("Error sending admin notification email:", error);
    return false;
  }
};

