const express = require("express");
const router = express.Router();
const adminController = require("../controllers/adminController");
const employeeController = require("../controllers/employeeController");
const { authenticateAdmin } = require("../middleware/authMiddleware");
const { loginLimiter } = require("../middleware/security");
const {
  validateLogin,
  validateEmployee,
  validateUpdateEmployee,
  validateStatus,
  validateEmployeeStatus,
  validateId,
  validateEmployeeId
} = require("../middleware/validation");

// Public route - Admin login (with rate limiting and validation)
router.post("/login", loginLimiter, validateLogin, adminController.adminLogin);

// Protected routes - require authentication
router.get("/stats", authenticateAdmin, adminController.getAdminStats);
router.get("/users", authenticateAdmin, adminController.getAllUsers);
router.get("/users/:userId", authenticateAdmin, validateId, adminController.getUserById);
router.patch("/users/:userId/status", authenticateAdmin, validateId, validateStatus, adminController.updateUserStatus);
router.get("/users/:userId/documents/:documentType", authenticateAdmin, validateId, adminController.downloadDocument);

// Employee Management Routes
router.get("/employees", authenticateAdmin, employeeController.getAllEmployees);
router.get("/employees/:employeeId", authenticateAdmin, validateEmployeeId, employeeController.getEmployeeById);
router.post("/employees", authenticateAdmin, validateEmployee, employeeController.createEmployee);
router.patch("/employees/:employeeId", authenticateAdmin, validateEmployeeId, validateUpdateEmployee, employeeController.updateEmployee);
router.delete("/employees/:employeeId", authenticateAdmin, validateEmployeeId, employeeController.deleteEmployee);
router.patch("/employees/:employeeId/status", authenticateAdmin, validateEmployeeId, validateEmployeeStatus, employeeController.updateEmployeeStatus);

module.exports = router;


