/**
 * Utility script to hash admin password
 * Usage: node utils/hashPassword.js <password>
 */

const bcrypt = require("bcryptjs");

const password = process.argv[2];

if (!password) {
  console.error("Usage: node utils/hashPassword.js <password>");
  process.exit(1);
}

(async () => {
  try {
    const hashedPassword = await bcrypt.hash(password, 10);
    console.log("\n✅ Password hashed successfully!");
    console.log("\nOriginal password:", password);
    console.log("Hashed password:", hashedPassword);
    console.log("\nAdd this to your .env file:");
    console.log(`ADMIN_PASSWORD=${hashedPassword}\n`);
  } catch (error) {
    console.error("Error hashing password:", error);
    process.exit(1);
  }
})();


