const express = require("express");
const router = express.Router();
const controller = require("../controllers/registrationController");
const multer = require("multer");
const fs = require("fs");
const path = require("path");

// Get the absolute path to uploads/tmp directory
const uploadsTmpDir = path.join(__dirname, "..", "uploads", "tmp");

// Create uploads/tmp directory if it doesn't exist
if (!fs.existsSync(uploadsTmpDir)) {
  fs.mkdirSync(uploadsTmpDir, { recursive: true });
  console.log("Created uploads/tmp directory at:", uploadsTmpDir);
}

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    // Double-check directory exists before saving
    if (!fs.existsSync(uploadsTmpDir)) {
      fs.mkdirSync(uploadsTmpDir, { recursive: true });
    }
    cb(null, uploadsTmpDir); // Use absolute path
  },
  filename: function (req, file, cb) {
    cb(null, Date.now() + "_" + file.originalname);
  },
});

const upload = multer({ storage });

router.post("/register", controller.registerUser);

router.post(
  "/upload-documents",
  upload.fields([
    { name: "aadhaar", maxCount: 1 },
    { name: "pan", maxCount: 1 },
    { name: "passport", maxCount: 1 },
    { name: "signature", maxCount: 1 },
    { name: "mou", maxCount: 1 },
  ]),
  controller.uploadDocuments
);

module.exports = router;
